/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler;

import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;

public class MemoryRange {
    private int address;
    private int rawAddress;
    private int length;
    private int[] values;

    public MemoryRange(int address, int length) {
        this.setAddress(address);
        this.setLength(length);
    }

    public int getAddress() {
        return this.address;
    }

    public void setAddress(int address) {
        this.address = address & 0x1FFFFFFF;
        this.rawAddress = address;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void updateValues() {
        this.values = new int[this.length >> 2];
        if (RuntimeContext.hasMemoryInt(this.address)) {
            System.arraycopy(RuntimeContext.getMemoryInt(), this.address >> 2, this.values, 0, this.values.length);
        } else {
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(this.rawAddress, this.length, 4);
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = memoryReader.readNext();
            }
        }
    }

    public boolean isOverlappingWithAddress(int address) {
        return this.address <= address && address < this.address + this.length;
    }

    public void extendBottom(int size) {
        this.setAddress(this.address - size);
        this.length += size;
    }

    public void extendTop(int size) {
        this.length += size;
    }

    public int getValue(int address) {
        return this.values[address - this.address >>> 2];
    }

    public boolean areValuesChanged() {
        if (RuntimeContext.hasMemoryInt(this.address)) {
            int[] memoryInt = RuntimeContext.getMemoryInt();
            int memoryIndex = this.address >> 2;
            int i = 0;
            while (i < this.values.length) {
                if (memoryInt[memoryIndex] != this.values[i]) {
                    return true;
                }
                ++i;
                ++memoryIndex;
            }
        } else {
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(this.rawAddress, this.length, 4);
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == memoryReader.readNext()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isOverlappingWithAddressRange(int address, int size) {
        if (address >= this.address + this.length || address + size < this.address) {
            return false;
        }
        if (this.isOverlappingWithAddress(address) || this.isOverlappingWithAddress(address + size)) {
            return true;
        }
        return address < this.address && address + size >= this.address + this.length;
    }

    public void free() {
        this.values = null;
    }

    public String toString() {
        return String.format("[0x%08X-0x%08X]", this.rawAddress, this.rawAddress + this.length);
    }
}

